//		-----------------------------------------
//		Cration d'images 89i pour Flib en 4 gris
//		           par Franois LEIBER
//		      Francois.leiber@laposte.net
//		            leiber.free.fr
//		          Compil avec Ti-gcc
//		 Librairies documentes par Zeljko Juric
//		              26/02/2001
//		-----------------------------------------


// Ce programme sert  transformer le texte renvoy par un programme de type BMP->C avec quatre niveaux de gris
// en deux images au format 89i, une pour chaque plane, pour pouvoir ensuite tre affich par Flib en gris.

// Je viens de tester  peu prs tous les programmes de type BMP->asm
// sur Ticalc/win/graphics. Mon verdict :
//
// - Graphics Studio : trs bien pour dessiner des images de n'importe quelle
// taille, et convertit bien certaines images car il a un trs bel effet de
// diffusion. Par contre, manque norme : pas moyen de rgler la luminosit au
// moment de la conversion, vous ne pouvez pas imaginer  quel point c'est important
// pour des images en quatre niveaux de gris. De plus, les images doivent avoir des
// tailles qui 'tombent rond' (multiples de 8 en horizontal et vertical, a finit
// par tre ennuyeux).
// - TiPaintPlus : bien, possibilit d'importation et de rglages, exportation possible
// sous de nombreux formats (C entre autres), peut-tre un peu lent.
// - Image Studio : une conversion extrmement simple avec tous les rglages
// ncessaires, mais pas de possibilit de corriger le fichier qu'on importe une
// fois qu'il est converti.
// - TIGCC Sprite Editor : simpliste, pour dessiner des sprites 8, 16, ou 32, mais
// trs pratique  l'usage, pas de fonction de conversion de BMP.
//
// Pour certains d'entre eux qui crent des fichiers asm 68K, il faut effectivement
// remplacer tous les $ par des 0x, virer les dc.b en dbut de ligne, 
// rajouter des virgules  la fin de chaque ligne et des accolades au dbut et  la fin.
// Ouf ! Mais bon, certains des logiciels
// (tigcc sprite editor) crent directement des textes pour le C.


// Pour voir s'il n'y a pas d'erreur, le programme affiche le rsultat, et attend que l'utilisateur appuie sur une touche.

// Attention, si vous vous trompez quelque part, ce programme risque de planter votre calculatrice, prenez vos prcautions !

#define OPTIMIZE_ROM_CALLS		// J'ai laiss dans le programme la dernire image que
#define NO_EXIT_SUPPORT			// j'ai convertie (je ne sais plus ce que c'est) pour servir d'exemple.
#define SAVE_SCREEN

#include <tigcclib.h>

short _ti89 ;		// Ce programme est aussi compatible pour les 92+, remplacez alors par _ti92.

void _main()
{
	static unsigned char plan0[] = {0, 100, 0, 160,		// Copier ici les donnes du plane gris fonc, les quatre premiers octets indiquent la taille verticale et horizontale de l'image.
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0x40,0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,0x01,0x0E,0x80,0x01,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0x04,0x38,0x28,0xCC,0x00,0x33,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0x02,0x3A,0x0F,0x10,0x6E,0x18,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,0x41,0x7B,0xD3,0x65,0x41,0x56,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x03,0xE3,0xFD,0xC6,0x66,0x50,0xCF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x02,0xF9,0xCD,0x80,0x25,0x70,0x91,0xE3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0x05,0xC0,0x20,0x00,0x84,0x91,0x00,0x15,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,0x0C,0x02,0x00,0x00,0x20,0x01,0x0A,0x50,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE0,0x02,0xC3,0x00,0x00,0x00,0x00,0x04,0x41,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,0x07,0x08,0x00,0x01,0x0F,0x00,0x05,0x00,0x5F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x00,0x00,0x00,0x1B,0xE0,0x06,0x84,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x04,0x10,0x00,0x10,0xC0,0x83,0x0A,0x43,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x05,0x4B,0x8F,0x00,0x05,0x07,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFD,0x00,0x01,0x02,0x00,0x01,0x2A,0x47,0xE0,0x03,0x88,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0x02,0x07,0x8E,0x10,0x00,0x02,0xFC,0x79,0x02,0x89,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,0x29,0x8E,0xFF,0x08,0x20,0x00,0x00,0x09,0x03,0xA1,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE4,0x18,0xF5,0xFD,0x80,0x00,0x02,0x00,0x00,0x03,0x01,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,0x5F,0x07,0xFA,0x80,0x40,0x04,0x90,0x06,0x1E,0x10,0x5F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x84,0x01,0x43,0xD0,0xC1,0x00,0x1C,0x41,0x40,0x00,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xA4,0xCF,0x3F,0xFD,0x20,0x14,0x02,0xA0,0x45,0x41,0x81,0x27,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x15,0xA6,0xD3,0xC6,0x40,0x18,0x00,0x01,0x2D,0x53,0xD0,0x97,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xBA,0xB7,0xBF,0xCD,0x10,0x00,0x60,0x01,0x19,0xB8,0xFA,0xBB,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0x62,0x4C,0xEF,0xD1,0x88,0x12,0x0C,0x04,0x78,0x5C,0x29,0xDF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0x22,0x80,0xDF,0xC9,0x10,0x13,0x68,0x86,0x24,0xF9,0x40,0x05,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFD,0x23,0xD6,0xFF,0xCF,0xC3,0xDA,0x00,0x00,0xB9,0x9C,0x00,0x07,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFB,0x43,0x1F,0xBE,0x65,0x02,0x08,0xA0,0x08,0x00,0x02,0x00,0x02,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFD,0x5A,0xF4,0x78,0x07,0x9C,0x80,0x02,0x08,0x28,0x00,0x03,0x02,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF9,0x84,0x7F,0xF0,0x01,0x22,0x00,0x0C,0xE0,0x06,0x00,0x0D,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,0x19,0x5F,0xE3,0x01,0x00,0x20,0x05,0xE0,0x2A,0x00,0x7D,0x43,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0x56,0xBF,0xCE,0x01,0xB0,0x00,0x1A,0x77,0x68,0x10,0xDF,0xC2,0xBF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,0xE8,0xCF,0xB8,0x0B,0x10,0x18,0x04,0x0C,0x08,0x00,0xFD,0xC0,0xBF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE1,0xD9,0xDD,0xEC,0x8A,0x22,0x01,0x3E,0x8C,0x04,0x01,0xFF,0xC1,0x9F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE2,0xFC,0x14,0x9C,0xB0,0x08,0x00,0x80,0xBF,0x73,0x7F,0xFB,0xE0,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE9,0x37,0x84,0x81,0x60,0x00,0x31,0x0E,0x11,0x66,0x9D,0xF7,0xE0,0x5F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,0xC3,0xA1,0xC5,0x20,0x00,0x60,0x88,0xD0,0x2B,0xFE,0x1F,0xE6,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC1,0xD2,0x8F,0x91,0xD2,0x02,0x56,0x40,0x76,0x5F,0xF6,0x05,0xF0,0x8F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC1,0xD3,0x5E,0x02,0x10,0x23,0x82,0x29,0x11,0x7B,0xBD,0x13,0xB0,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE2,0xE4,0xEE,0xF7,0xA0,0x24,0x52,0x0F,0xE7,0xEE,0xFF,0x47,0xB8,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE3,0x90,0x3F,0xFF,0x6D,0xF0,0x81,0xFE,0x6F,0xFF,0xEB,0xEF,0xA2,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE2,0xDA,0x0F,0xCF,0xFE,0x20,0x23,0xFF,0xAB,0xFE,0xF7,0xF7,0x81,0x2F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE0,0xCE,0x7F,0xF7,0xC0,0x60,0x0E,0xBF,0xFF,0xFC,0xE5,0xFF,0x00,0x4F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF4,0xC1,0x3F,0xBC,0x01,0x80,0x19,0xFF,0x87,0xF5,0xBD,0xCF,0xC0,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,0x70,0xFF,0xB0,0x06,0xD0,0x77,0xFF,0x7B,0xFF,0x6E,0x8E,0x20,0x4F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF3,0x6F,0xFF,0xC0,0x00,0x01,0x5F,0xFF,0xFF,0xBF,0x93,0x3E,0xC0,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFB,0xC3,0xFB,0x80,0x04,0x70,0x3B,0xFF,0xFD,0x7F,0xFF,0xFE,0x26,0x4F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF7,0x74,0x84,0x00,0x6D,0x7F,0xFF,0xED,0x7B,0xF4,0xB3,0x40,0x9F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE4,0x85,0x11,0x82,0xFF,0xFF,0xDC,0xFF,0xFF,0x4E,0x80,0xAF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xBF,0xF1,0x20,0x6B,0xA1,0xFF,0xFF,0xD1,0xF7,0xFC,0x68,0x00,0x2F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xB6,0x10,0xF3,0xA7,0xFF,0x7F,0xE3,0xE7,0xC7,0xE0,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xEC,0x93,0xFB,0x4B,0xFF,0x3F,0xEF,0xE9,0x3F,0xF4,0x01,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x27,0xFF,0x56,0x9B,0xBF,0xFE,0x63,0xE5,0xFF,0xF8,0x04,0x6F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xEF,0xDB,0xDF,0xDE,0x23,0xBF,0xFE,0xF7,0xC7,0xFF,0xF0,0x04,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xCF,0xCF,0xE6,0xBC,0x17,0xBF,0xB9,0xEC,0xFF,0xFF,0x70,0x00,0x8F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xDF,0xFF,0xFF,0x3C,0x13,0xFF,0xB5,0xC9,0x27,0xC3,0xA8,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7F,0xFC,0xFA,0xDE,0xFF,0xFC,0x01,0x38,0x01,0x70,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFD,0xD9,0xFE,0x7F,0xBC,0x02,0xA6,0xA1,0xF0,0x03,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF1,0x1F,0xFF,0xA9,0x41,0x80,0x03,0xE8,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFD,0xE6,0xDF,0xFF,0xE8,0xA1,0x08,0x03,0xF8,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFD,0xDB,0x2F,0xFF,0x8C,0xE3,0xA0,0x02,0xCA,0x45,0xBF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFB,0xFA,0xFD,0xF7,0x8C,0xB0,0x66,0x83,0x01,0x8D,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x67,0xFF,0xBF,0x08,0x81,0x60,0x82,0x3B,0x39,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7F,0xFF,0xFC,0x00,0x05,0x00,0x12,0x08,0xF9,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xBF,0xEF,0xFF,0x11,0x45,0x06,0x50,0x99,0x34,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFD,0x2C,0x11,0xDA,0xFE,0xAE,0x07,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFB,0xFF,0xCF,0xBD,0x36,0x0C,0xFE,0x5F,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xDF,0xBF,0xB4,0x63,0xAB,0x6A,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFB,0x7F,0x4A,0x86,0x10,0x20,0x00,0x87,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x83,0xCA,0xAC,0x60,0x07,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xEF,0x7F,0x29,0x94,0x00,0x00,0x0C,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF5,0x3E,0x00,0xF8,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xEC,0xD7,0x01,0xF8,0x8B,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF2,0xBF,0x07,0xE5,0x8F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x17,0xF9,0xCF,0x69,0xBF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x4F,0xFF,0x0F,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF2,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF} ;
	static unsigned char plan1[] = {0, 100, 0, 160,		// Ici les donnes du plane gris clair
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x07,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,0x00,0x02,0x00,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0x00,0x00,0x77,0x82,0x01,0xC3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0x13,0xFF,0xFF,0xC8,0xF1,0xE0,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE0,0x0E,0xDF,0xEB,0xCA,0x9E,0xA8,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x09,0xA7,0xF1,0xE0,0x04,0xA8,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x1F,0xF0,0x00,0x78,0x05,0x20,0x07,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0x1B,0x00,0x08,0x01,0x50,0x00,0x01,0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0x10,0x04,0x00,0x01,0xC0,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,0x07,0xE4,0x00,0x01,0xF0,0x00,0x00,0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,0x1F,0xF8,0x00,0x01,0xFE,0x00,0x01,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x00,0x00,0x03,0xEF,0xF8,0x01,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x60,0x00,0xCD,0x3C,0x08,0x41,0x87,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0x00,0x00,0x08,0x30,0x00,0x05,0x8E,0x01,0x00,0xC3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x02,0x10,0x00,0x00,0x07,0xBF,0x99,0x03,0x41,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x4F,0xEF,0x00,0x00,0x01,0x7C,0x3D,0x00,0x20,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,0x20,0xE7,0xCF,0x86,0x00,0x00,0x06,0x01,0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE0,0x00,0xFF,0xFE,0x84,0x00,0x00,0x01,0x80,0x04,0x80,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,0x07,0x37,0xFD,0x60,0x00,0x03,0x08,0x00,0x9F,0xE0,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,0x6F,0xFD,0xFC,0xD0,0x10,0x03,0x01,0x08,0x89,0xF0,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x81,0x17,0xFF,0xFF,0x60,0x08,0x10,0x03,0x03,0x61,0xFA,0xC7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x01,0x1B,0xFF,0xD7,0x80,0x00,0x88,0x46,0xB1,0x50,0xEF,0x47,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x01,0x5F,0xFF,0xD8,0xE0,0x00,0x81,0x0A,0x31,0xF8,0xE5,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0x18,0xCE,0xFF,0xC3,0x2F,0x00,0x30,0x42,0x08,0xFC,0x48,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0x59,0xB9,0xFF,0xEB,0xAD,0x12,0x06,0x40,0x08,0xEA,0x08,0xC1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0x17,0x2F,0xFF,0x67,0xC2,0x00,0x01,0x80,0x0E,0xAE,0x08,0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0xBC,0x3F,0xFC,0x01,0x40,0x00,0x41,0xB0,0x5A,0x00,0x01,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0x3C,0xEF,0xF8,0x01,0x81,0x00,0x01,0xE0,0x02,0x80,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,0x66,0xFF,0xE9,0x00,0x88,0x00,0x03,0xA0,0x74,0x00,0x8F,0xE2,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,0x05,0xF3,0xF6,0x00,0x90,0x00,0x0E,0x00,0xD0,0x00,0x7F,0x60,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,0x2F,0xDF,0xFF,0x00,0x80,0x00,0x0D,0x88,0xBC,0x00,0x5F,0x70,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xEA,0xFF,0x3F,0xDE,0x11,0x20,0x03,0xDE,0x15,0xAC,0x12,0x7E,0xF1,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0x7F,0xFF,0xEE,0x8C,0x00,0x11,0x08,0x35,0x6D,0x00,0xFB,0xF0,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFD,0xFF,0x1C,0x3E,0xC0,0x04,0x0A,0x20,0x3F,0xE7,0xFE,0xBF,0xF0,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF7,0xFF,0x9E,0xBF,0x40,0x00,0x2D,0x9C,0x1F,0xBF,0xBE,0x3F,0xF0,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0x7E,0xC7,0x10,0x00,0x45,0xD6,0x1F,0xFF,0xFF,0x37,0xF0,0x9F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xAC,0x5F,0x53,0xF0,0x00,0x61,0xA6,0x0F,0xBF,0xFF,0x1B,0xF8,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xA4,0x9E,0xCC,0x60,0x07,0xE8,0x1E,0x9D,0xFF,0xFF,0x13,0xF8,0x8F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xD1,0x9E,0xF1,0xF0,0x1B,0x88,0x3F,0xC3,0xFF,0xFD,0x83,0xA2,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x60,0xEC,0xEF,0x94,0xE5,0x29,0xFF,0xCF,0xFF,0xFF,0xE3,0xF0,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFD,0x02,0xAF,0xFF,0xE9,0x80,0x1B,0xFF,0xF7,0xFF,0xEF,0xFB,0xB0,0x4F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x10,0xBF,0xFE,0x00,0x80,0x0F,0xFF,0xF7,0xF3,0xFF,0xF7,0xB0,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x39,0xBF,0xF8,0x01,0xC0,0x1B,0xFF,0x97,0xEF,0xBF,0xFF,0xB0,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC7,0x7F,0xE0,0x01,0xC8,0x3F,0xFF,0xFF,0xFF,0x77,0xDF,0xF0,0x8F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFB,0xFF,0xA0,0x06,0x00,0x7F,0xFF,0xF3,0xBF,0xFC,0xFF,0x20,0x8F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x0C,0x29,0xFF,0xFF,0xF7,0xFF,0xFF,0xEF,0x41,0xAF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xCF,0xFB,0x00,0xA5,0x21,0xFF,0xFF,0xFF,0xFB,0xFF,0xCE,0x01,0x6F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFB,0x81,0x0F,0xA1,0xFF,0xFF,0xFF,0xFF,0xFF,0x8C,0x81,0xCF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFB,0x10,0x0B,0xC3,0xFF,0xFF,0xFE,0xFF,0xF9,0xF8,0x02,0xCF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x77,0x7B,0x5F,0x03,0xFF,0x7F,0xFD,0xEF,0x8F,0xE0,0x05,0xEF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC4,0xFD,0xDF,0x8F,0xFF,0x3F,0xFF,0xFF,0x7F,0xF8,0x07,0x6F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xCF,0xFF,0xFE,0x13,0x9F,0xFE,0xE7,0xF3,0xFF,0xF0,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0x1F,0xFF,0xFF,0xB7,0xD7,0xFF,0xF0,0x00,0x6F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xBC,0x37,0xFF,0xB9,0xED,0x9F,0xFF,0x60,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xDF,0xFA,0xFE,0x2F,0xFF,0xB9,0xF8,0xBF,0xFF,0xE0,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7F,0xFF,0xFC,0x3F,0xFF,0xBB,0x83,0x7A,0xE1,0xF0,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0x7E,0xFF,0xB9,0x56,0xF8,0x03,0xF0,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,0x7F,0xFD,0xA8,0x60,0x80,0x03,0xE0,0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xD1,0x7F,0xFF,0xEE,0xC1,0x01,0x83,0xF0,0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF2,0x7F,0xFF,0xE6,0x83,0x8D,0x02,0xC0,0x02,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC1,0x67,0x9E,0x03,0x04,0x02,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x8F,0x64,0x07,0x05,0x00,0x06,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xDD,0xC8,0x3B,0xC4,0x07,0x06,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC5,0x86,0x23,0xF4,0x06,0xCB,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xDF,0xFF,0xD2,0x00,0x05,0xE1,0x11,0xF9,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xBF,0xDE,0x29,0x8B,0xE0,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xDC,0x00,0x95,0xB1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xDC,0x0B,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xCC,0x30,0x7B,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xDE,0x69,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xEE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF} ;
	static char nom0[] = "pic0" ;						// Ici les noms  donner aux deux images.
	static char nom1[] = "pic1" ;
	short taille = plan0[1]*((plan0[3]+7)>>3)+4 ;
	char *var, nom[19] = {} ;
	SYM_ENTRY *entry ;

	GrayOn() ;					// Initialise l'affichage pour afficher votre cration, et voir s'il n'y a pas de problmes.
	SetPlane(0) ;
	ClrScr() ;
	BitmapPut(0, 0, &plan0, &(SCR_RECT){{0,0,159,99}}, 4) ;	// Affiche les deux planes.
	SetPlane(1) ;
	ClrScr() ;
	BitmapPut(0, 0, &plan1, &(SCR_RECT){{0,0,159,99}}, 4) ;

	entry = DerefSym(SymAdd(strcpy(nom+1, nom0)+strlen(nom0))) ;		// Cre la premire image.
	var = (unsigned char*)HeapDeref(entry->handle = HeapAlloc(taille+3)) ;
	var[0] = (taille+1)/256 ;
	var[1] = (taille+1)%256 ;
	memcpy(var+2, plan0, taille) ;
	var[taille+2] = 0xDF ;

	entry = DerefSym(SymAdd(strcpy(nom+1, nom1)+strlen(nom1))) ;		// Cre la deuxime image.
	var = (unsigned char*)HeapDeref(entry->handle = HeapAlloc(taille+3)) ;
	var[0] = (taille+1)/256 ;
	var[1] = (taille+1)%256 ;
	memcpy(var+2, plan1, taille) ;
	var[taille+2] = 0xDF ;

	ngetchx() ;					// Attend l'appui sur une touche pour que vous puissiez admirer :)
	GrayOff() ;
}
